<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\Instagram\Filters
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Add new data source type for CSV
 *
 * @since 1.0.0
 *
 * @param array  $sources         The sources array.
 *
 * @return array
 */
function automatorwp_instagram_add_data_source ( $sources ) {
    
    $sources['instagram'] = __( 'Instagram', 'automatorwp-pro' );
    
    return $sources;

}

add_filter( 'automatorwp_csv_data_sources', 'automatorwp_instagram_add_data_source' );

/**
 * Add Instagram selection fields for CSV
 *
 * @since 1.0.0
 *
 * @param array  $fields         The fields array.
 *
 * @return array
 */
function automatorwp_instagram_add_select_fields_csv ( $fields ) {
    
    $fields = array_merge( $fields, array(
        'spreadsheet' => automatorwp_utilities_ajax_selector_field( array(
            'field'             => 'spreadsheet',
            'option_default'    => __( 'spreadsheet', 'automatorwp-pro' ),
            'placeholder'       => __( 'Select a spreadsheet', 'automatorwp-pro' ),
            'name'              => __( 'Spreadsheet:', 'automatorwp-pro' ),
            'action_cb'         => 'automatorwp_instagram_get_spreadsheets',
            'options_cb'        => 'automatorwp_instagram_options_cb_spreadsheets',
            'default'           => ''
        ) ),
        'worksheet' => automatorwp_utilities_ajax_selector_field( array(
            'field'             => 'worksheet',
            'option_default'    => __( 'worksheet', 'automatorwp-pro' ),
            'placeholder'       => __( 'Select a worksheet', 'automatorwp-pro' ),
            'name'              => __( 'Worksheet:', 'automatorwp-pro' ),
            'action_cb'         => 'automatorwp_instagram_get_worksheets',
            'options_cb'        => 'automatorwp_instagram_options_cb_worksheets',
            'default'           => ''
        ) ),
    ) );

    return $fields;

}

add_filter( 'automatorwp_import_csv_fields_after_csv_text', 'automatorwp_instagram_add_select_fields_csv' );

/**
 * Get data from Instagram
 *
 * @since 1.0.0
 *
 * @param string    $url
 * @param bool      $exclude_header
 * @param string    $skip_rows
 * @param string    $limit_rows
 * @param array     $trigger_options
 *
 * @return array
 */
function automatorwp_csv_get_data_from_instagram ( $exclude_header, $skip_rows, $limit_rows, $trigger_options ){

    $spreadsheet_id = $trigger_options['spreadsheet'];
    $worksheet_id = $trigger_options['worksheet'];

    $data = array();

    // Exclude headers if enabled
    if ( $exclude_header )
        $skip_rows += 1;

    // Limit rows to null if 0
    if ( absint( $limit_rows ) === 0 )
        $limit_rows = null;

    $range = 'A:Z';

    // Data from worksheet
    $result = automatorwp_instagram_get_data_from_worksheet( $spreadsheet_id, $worksheet_id, $range );

    if ( !$result )
        return array();
    
    // Rows to use
    $data = ( $limit_rows !== null ) ? array_slice( $result, $skip_rows, $limit_rows ) : array_slice( $result, $skip_rows );
    
    return $data;

}
add_filter( 'automatorwp_import_files_get_data_custom_source', 'automatorwp_csv_get_data_from_instagram', 10, 4 );
